-- phpMyAdmin SQL Dump
-- version 4.7.9
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Mar 22, 2019 at 01:58 PM
-- Server version: 5.7.21
-- PHP Version: 7.1.16

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `ss_work`
--

-- --------------------------------------------------------

--
-- Table structure for table `app_images`
--

DROP TABLE IF EXISTS `app_images`;
CREATE TABLE IF NOT EXISTS `app_images` (
  `img_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `image_type` enum('Aadhar Card','PAN Card','Voter ID','Driving License','Profile Photo') NOT NULL,
  `image_path` varchar(100) NOT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`img_id`),
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `child_categories`
--

DROP TABLE IF EXISTS `child_categories`;
CREATE TABLE IF NOT EXISTS `child_categories` (
  `child_id` int(11) NOT NULL AUTO_INCREMENT,
  `sub_category_name` varchar(100) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `child_category_img_path` varchar(150) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`child_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `child_categories`
--

INSERT INTO `child_categories` (`child_id`, `sub_category_name`, `parent_id`, `child_category_img_path`, `created_at`, `created_by`, `updated_by`, `updated_at`, `active`) VALUES
(1, 'marketing', 1, '', 1544077825, 1, 0, 0, 1),
(2, 'fighter', 3, '', 1544077825, 1, 0, 0, 1),
(3, 'Electrician', 1, '', 1544077825, 1, 0, 0, 1),
(4, 'Plumber', 3, 'uploads/1001-Chrysanthemum.jpg', 1544077825, 1, 1001, 1551810600, 1),
(5, 'Electronics Service engg', 5, 'uploads/1001-Jellyfish.jpg', 1548959400, 1001, 1001, 1551033000, 1),
(6, 'second test1', 1, '', 1552242600, 1001, 0, 0, 1),
(7, 'testA1', 8, 'uploads/1001-Lighthouse', 1552242600, 1001, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `child_category_parameters`
--

DROP TABLE IF EXISTS `child_category_parameters`;
CREATE TABLE IF NOT EXISTS `child_category_parameters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title_id` int(11) NOT NULL,
  `description` text NOT NULL,
  `sort_order` int(5) NOT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FN_PARAMETER_TITLE_ID` (`title_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `child_category_parameters`
--

INSERT INTO `child_category_parameters` (`id`, `title_id`, `description`, `sort_order`, `active`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(1, 1, '<p><em>Lorem ipsum dolor sit amet, cod do</em></p>\r\n<p><strong>eiusmod tempor incididunt ut labore et dolore magna aliqua</strong></p>', 1, 1, 1551551400, 1001, NULL, NULL),
(2, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit</p>', 2, 1, 1551551400, 1001, NULL, NULL),
(3, 1, 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua', 3, 1, 1551551400, 1001, NULL, NULL),
(4, 1, 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua', 4, 1, 1551551400, 1001, NULL, NULL),
(5, 1, 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua', 5, 1, 1551551400, 1001, NULL, NULL),
(6, 1, 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua test', 6, 1, 1551551400, 1001, 1551810600, 1001);

-- --------------------------------------------------------

--
-- Table structure for table `information`
--

DROP TABLE IF EXISTS `information`;
CREATE TABLE IF NOT EXISTS `information` (
  `info_id` int(11) NOT NULL AUTO_INCREMENT,
  `app_version` decimal(10,0) NOT NULL,
  `vendor_name` varchar(100) NOT NULL,
  `vendor_email` varchar(100) NOT NULL,
  `client_name` varchar(100) NOT NULL,
  `client_email` varchar(100) NOT NULL,
  `privacy_policy` text NOT NULL,
  `terms_policy` text NOT NULL,
  `about_app` text NOT NULL,
  `payment_policy` text NOT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`info_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
CREATE TABLE IF NOT EXISTS `jobs` (
  `job_id` int(11) NOT NULL AUTO_INCREMENT,
  `request_id` int(11) NOT NULL,
  `assigned_to` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `estimated_duration` decimal(10,0) DEFAULT NULL,
  `completed_on` int(11) DEFAULT NULL,
  `status_id` int(11) NOT NULL DEFAULT '2',
  `active` int(1) NOT NULL DEFAULT '1',
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`job_id`),
  KEY `request_id` (`request_id`),
  KEY `assigned_to` (`assigned_to`),
  KEY `transaction_id` (`transaction_id`),
  KEY `status_id` (`status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `job_images`
--

DROP TABLE IF EXISTS `job_images`;
CREATE TABLE IF NOT EXISTS `job_images` (
  `job_img_id` int(11) NOT NULL AUTO_INCREMENT,
  `job_request_id` int(11) NOT NULL,
  `image_path` varchar(100) NOT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`job_img_id`),
  KEY `job_id` (`job_request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `job_requests`
--

DROP TABLE IF EXISTS `job_requests`;
CREATE TABLE IF NOT EXISTS `job_requests` (
  `request_id` int(11) NOT NULL AUTO_INCREMENT,
  `posted_by` int(11) NOT NULL,
  `posted_at` int(11) NOT NULL,
  `details_id` int(11) NOT NULL,
  `reject_reason` text,
  `accepted_at` int(11) DEFAULT NULL,
  `rejected_at` int(11) DEFAULT NULL,
  `rejected_by` int(11) DEFAULT NULL,
  `job_description` text NOT NULL,
  `ref_img` int(1) DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`request_id`),
  KEY `details_id` (`details_id`) USING BTREE,
  KEY `posted_by` (`posted_by`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `job_requests`
--

INSERT INTO `job_requests` (`request_id`, `posted_by`, `posted_at`, `details_id`, `reject_reason`, `accepted_at`, `rejected_at`, `rejected_by`, `job_description`, `ref_img`, `active`) VALUES
(1, 1017, 1553059423, 16, NULL, NULL, NULL, 1017, 'malual Test', 0, 1),
(2, 1018, 1553059423, 17, 'asdf', NULL, 1553193000, 1002, 'malual Test', 0, 1),
(3, 1019, 1553059423, 17, NULL, NULL, NULL, 1019, 'malual Test', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
CREATE TABLE IF NOT EXISTS `menus` (
  `menu_id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) NOT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `my_calendar`
--

DROP TABLE IF EXISTS `my_calendar`;
CREATE TABLE IF NOT EXISTS `my_calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `available_date` int(11) NOT NULL,
  `user_status` varchar(25) NOT NULL,
  `user_id` int(11) NOT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `my_calendar`
--

INSERT INTO `my_calendar` (`id`, `available_date`, `user_status`, `user_id`, `active`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(1, 1553106600, 'Available', 1002, 0, 1550663252, 1002, NULL, NULL),
(2, 1553106600, 'Available', 1003, 0, 1550663252, 1002, NULL, NULL),
(3, 1553106600, 'Available', 1004, 0, 1550663252, 1002, NULL, NULL),
(4, 1553106600, 'Available', 1006, 0, 1550663252, 1002, NULL, NULL),
(5, 1553106600, 'Available', 1011, 0, 1550663252, 1002, NULL, NULL),
(6, 1553106600, 'Available', 1015, 1, 1550663252, 1002, NULL, NULL),
(8, 1553106600, 'Available', 1017, 1, 1550663252, 1002, NULL, NULL),
(9, 1553106600, 'Available', 1020, 1, 1550663252, 1002, NULL, NULL),
(10, 1553106600, 'Available', 1023, 1, 1550663252, 1002, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `otp_verification`
--

DROP TABLE IF EXISTS `otp_verification`;
CREATE TABLE IF NOT EXISTS `otp_verification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `phone_email` varchar(75) NOT NULL,
  `email_otp` varchar(25) DEFAULT NULL,
  `mobile_otp` varchar(25) DEFAULT NULL,
  `mobile_verified` int(1) NOT NULL DEFAULT '0',
  `email_verified` int(1) NOT NULL DEFAULT '0',
  `created_at` int(11) NOT NULL,
  `expiry_at` int(11) NOT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `otp_verification`
--

INSERT INTO `otp_verification` (`id`, `phone_email`, `email_otp`, `mobile_otp`, `mobile_verified`, `email_verified`, `created_at`, `expiry_at`, `active`) VALUES
(1, '9597207343', NULL, '60vbj5', 1, 0, 1549017065, 1549017665, 1);

-- --------------------------------------------------------

--
-- Table structure for table `parameter_title`
--

DROP TABLE IF EXISTS `parameter_title`;
CREATE TABLE IF NOT EXISTS `parameter_title` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `sort_order` int(5) NOT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  `service_id` int(11) NOT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `serive_id` (`service_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `parameter_title`
--

INSERT INTO `parameter_title` (`id`, `title`, `sort_order`, `active`, `service_id`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(1, 'DDDDD', 1, 1, 3, 1551551400, 1001, NULL, NULL),
(2, 'CCCC', 2, 1, 3, 1551551400, 1001, 1551810600, 1001),
(3, 'New AC fixing', 1, 1, 1, 1551551400, 1001, NULL, NULL),
(4, 'Electronics Service 1', 1, 1, 4, 1551551400, 1001, NULL, NULL),
(5, 'EEEEEE2', 1, 1, 2, 1551983400, 1001, 1551983400, 1001);

-- --------------------------------------------------------

--
-- Table structure for table `parent_categories`
--

DROP TABLE IF EXISTS `parent_categories`;
CREATE TABLE IF NOT EXISTS `parent_categories` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(50) NOT NULL,
  `sort_order` int(5) NOT NULL,
  `category_img_path` varchar(150) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `parent_categories`
--

INSERT INTO `parent_categories` (`category_id`, `category_name`, `sort_order`, `category_img_path`, `created_at`, `created_by`, `updated_at`, `updated_by`, `active`) VALUES
(1, 'Admin', 1, 'uploads/1001-Chrysanthemum.jpg', 1544077825, 1, 0, 0, 1),
(2, 'test2', 2, 'uploads/1001-Chrysanthemum.jpg', 1544077825, 1, 0, 0, 1),
(3, 'Plumbing', 4, 'uploads/1001-Tulips.jpg', 1548873000, 1001, 1551897000, 1001, 1),
(4, 'Electrical', 3, 'uploads/1001-Chrysanthemum.jpg', 1548959400, 1001, 0, 0, 1),
(5, 'Electronics', 5, 'uploads/1001-Tulips.jpg', 1548959400, 1001, 1551897000, 1001, 1),
(6, 'testaaa', 6, 'uploads/1001-Tulips.jpg', 1552242600, 1001, 0, 0, 1),
(7, 'hello', 7, '', 1552242600, 1001, 1552242600, 1001, 1),
(8, 'test1', 10, '', 1552242600, 1001, 0, 0, 1),
(9, 'test2', 11, 'uploads/1001-Desert.jpg', 1552242600, 1001, 0, 0, 1),
(10, 'Super Admin', 1, 'uploads/1001-Chrysanthemum.jpg', 1544077825, 1, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `plans`
--

DROP TABLE IF EXISTS `plans`;
CREATE TABLE IF NOT EXISTS `plans` (
  `plan_id` int(11) NOT NULL AUTO_INCREMENT,
  `plan_name` varchar(50) NOT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`plan_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `plans`
--

INSERT INTO `plans` (`plan_id`, `plan_name`, `amount`, `created_at`, `created_by`, `updated_at`, `updated_by`, `active`) VALUES
(1, '1 Month', 3859.00, 1543738929, 1, 0, 0, 1),
(2, '3 Months', 10767.00, 1543738929, 1, 0, 0, 1),
(3, '6 Months', 21534.00, 1543738929, 1, 0, 0, 1),
(4, '12 Months', 43068.00, 1543738929, 1, 0, 0, 1),
(5, '48 Months', 172272.00, 1543738929, 1, 0, 0, 1),
(6, '60 Months', 215340.00, 1543738929, 1, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `rights`
--

DROP TABLE IF EXISTS `rights`;
CREATE TABLE IF NOT EXISTS `rights` (
  `right_id` int(11) NOT NULL AUTO_INCREMENT,
  `right_name` varchar(50) NOT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`right_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rights`
--

INSERT INTO `rights` (`right_id`, `right_name`, `created_at`, `created_by`, `updated_at`, `updated_by`, `active`) VALUES
(1, 'CREATE', 1543738929, 1, 0, 0, 1),
(2, 'EDIT', 1543738929, 1, 0, 0, 1),
(3, 'VIEW ALL', 1543738929, 1, 0, 0, 1),
(4, 'VIEW', 1543738929, 1, 0, 0, 1),
(5, 'DELETE', 1543738929, 1, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
CREATE TABLE IF NOT EXISTS `roles` (
  `role_id` int(11) NOT NULL AUTO_INCREMENT,
  `role_name` varchar(50) NOT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`role_id`, `role_name`, `created_at`, `created_by`, `updated_at`, `updated_by`, `active`) VALUES
(1, 'Administrator', 1543738929, 1, 1552949750, 1001, 1),
(2, 'Service Provider', 1543738929, 1, 1551033000, 1001, 1),
(3, 'Customer', 1543738929, 1, 0, 0, 1),
(4, 'Super Admin', 1551057872, 1001, 1551994136, 1001, 1);

-- --------------------------------------------------------

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
CREATE TABLE IF NOT EXISTS `services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child_id` int(11) NOT NULL,
  `service_name` varchar(100) NOT NULL,
  `default_price` float(10,2) NOT NULL DEFAULT '0.00',
  `offer_price` float(10,2) NOT NULL DEFAULT '0.00',
  `discount` varchar(50) DEFAULT NULL,
  `discounted_price` float(10,2) NOT NULL DEFAULT '0.00',
  `is_best_seller` int(1) NOT NULL DEFAULT '0',
  `service_image` varchar(100) DEFAULT NULL,
  `min_visit_price` float(10,2) NOT NULL DEFAULT '0.00',
  `active` int(1) NOT NULL DEFAULT '1',
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_CHILD_CAT_SERVICE` (`child_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `services`
--

INSERT INTO `services` (`id`, `child_id`, `service_name`, `default_price`, `offer_price`, `discount`, `discounted_price`, `is_best_seller`, `service_image`, `min_visit_price`, `active`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(1, 5, 'Electronics Service 1', 1450.00, 1305.00, '100', 145.00, 1, 'uploads/services/1001-intr2.jpg', 24.00, 1, 1551404160, 1001, 1552008134, 1001),
(2, 2, 'Bathroom Tap fixing', 620.00, 500.00, '100', 124.00, 0, 'uploads/services/1001-no-profile-img.png', 0.00, 1, 1551728025, 1001, 1552947290, 1001),
(3, 3, 'Light fixing', 620.00, 500.00, '20', 124.00, 0, 'uploads/services/1001-profile-update-fail-app.png', 0.00, 1, 1551728167, 1001, NULL, NULL),
(4, 3, 'New AC fixing', 1300.00, 1200.00, '10', 0.00, 1, '', 0.00, 1, 1551729120, 1001, 1552008272, 1001),
(5, 3, 'New Electric Metere fixing', 4500.00, 0.00, '10', 0.00, 0, '', 0.00, 0, 1551729230, 1001, 1552008260, 1001),
(6, 3, 'New Electric Metere fixing', 4500.00, 0.00, '50', 0.00, 0, '', 0.00, 1, 1551905323, 1001, 1552008252, 1001),
(7, 1, 'test', 1500.00, 1000.00, '25', 37.50, 1, 'uploads/services/', 0.00, 0, 1552008308, 1001, 1552933800, 1001),
(8, 1, 'testing', 100.00, 10.00, '9', 10.00, 1, 'uploads/services/', 0.00, 0, 1552008505, 1001, 1552933800, 1001),
(9, 1, 'hello', 0.00, 10.00, '2', 0.00, 1, 'uploads/services/1001-google-pacman-796x419.jpg', 99.00, 1, 1552958827, 1001, 1552959339, 1001);

-- --------------------------------------------------------

--
-- Table structure for table `service_provider_job_temp`
--

DROP TABLE IF EXISTS `service_provider_job_temp`;
CREATE TABLE IF NOT EXISTS `service_provider_job_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `request_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `phone` bigint(20) NOT NULL,
  `email_sent` int(1) NOT NULL DEFAULT '0',
  `sms_sent` int(1) NOT NULL DEFAULT '0',
  `is_rejected` int(1) NOT NULL DEFAULT '0',
  `rejected_at` int(11) NOT NULL DEFAULT '0',
  `is_time_delay_expired` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_JOB_TEMP_REQ_ID` (`request_id`),
  KEY `FK_JOB_TEMP_USER_ID` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `service_provider_job_temp`
--

INSERT INTO `service_provider_job_temp` (`id`, `user_id`, `request_id`, `user_name`, `email`, `phone`, `email_sent`, `sms_sent`, `is_rejected`, `rejected_at`, `is_time_delay_expired`) VALUES
(1, 1003, 3, 'Aravinth', '9003031003', 9003031003, 0, 0, 0, 1553193000, 0),
(2, 1002, 3, 'Vinith', 'Vinith@avthedigiworks.com', 9003031003, 0, 0, 1, 1553193000, 0);

-- --------------------------------------------------------

--
-- Table structure for table `status`
--

DROP TABLE IF EXISTS `status`;
CREATE TABLE IF NOT EXISTS `status` (
  `status_id` int(11) NOT NULL AUTO_INCREMENT,
  `status_name` varchar(50) NOT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `status`
--

INSERT INTO `status` (`status_id`, `status_name`, `created_at`, `created_by`, `updated_at`, `updated_by`, `active`) VALUES
(1, 'Open', 1550663252, 1001, 0, 0, 1),
(2, 'Assigned', 1550663252, 1001, 0, 0, 1),
(3, 'Job Initiated', 1550663252, 1001, 0, 0, 1),
(4, 'Job Rework', 1550663252, 1001, 0, 0, 1),
(5, 'Job Re-assignment', 1550663252, 1001, 0, 0, 1),
(6, 'Job Completed', 1550663252, 1001, 0, 0, 1),
(7, 'Transaction Completed', 1550663252, 1001, 0, 0, 1),
(8, 'Job Closed', 1550663252, 1001, 0, 0, 1),
(9, 'Job Rejected', 1550663252, 1001, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `subscriptions`
--

DROP TABLE IF EXISTS `subscriptions`;
CREATE TABLE IF NOT EXISTS `subscriptions` (
  `subscription_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `plan_id` int(11) NOT NULL,
  `is_expired` int(1) NOT NULL,
  `start_date` int(11) NOT NULL DEFAULT '0',
  `end_date` int(11) NOT NULL DEFAULT '0',
  `transaction_id` int(11) DEFAULT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  PRIMARY KEY (`subscription_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `plan_id` (`plan_id`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `subscriptions`
--

INSERT INTO `subscriptions` (`subscription_id`, `user_id`, `plan_id`, `is_expired`, `start_date`, `end_date`, `transaction_id`, `active`, `created_at`, `created_by`) VALUES
(2, 1001, 6, 0, 1543738929, 1733127729, 1, 1, 1543738929, 1),
(3, 1003, 2, 0, 1543738929, 1543996887, 2, 1, 1543738929, 1),
(4, 1003, 3, 1, 0, 0, NULL, 1, 1544080375, 1);

-- --------------------------------------------------------

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
CREATE TABLE IF NOT EXISTS `transactions` (
  `transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `amount` decimal(10,0) NOT NULL,
  `paid_on` int(11) NOT NULL,
  `paid_through` enum('Cash','Card','Wire','Cheque') NOT NULL,
  `bank` varchar(100) DEFAULT NULL,
  `transaction_cheque` int(11) DEFAULT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `comments` text,
  PRIMARY KEY (`transaction_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `transactions`
--

INSERT INTO `transactions` (`transaction_id`, `user_id`, `amount`, `paid_on`, `paid_through`, `bank`, `transaction_cheque`, `active`, `created_at`, `created_by`, `updated_at`, `updated_by`, `comments`) VALUES
(1, 1001, '500', 1543738929, 'Cash', NULL, 13748893, 1, 1543738929, 1, 0, 0, NULL),
(2, 1003, '500', 1543738929, 'Cash', NULL, 13748893, 1, 1543738929, 1, 0, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `sub_category_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `access_token` varchar(150) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `logged_from` enum('mobile','web') NOT NULL DEFAULT 'mobile',
  `last_logged_on` int(11) DEFAULT NULL,
  `is_internal` int(1) NOT NULL DEFAULT '0',
  `lattitude` bigint(20) DEFAULT NULL,
  `longitude` bigint(20) DEFAULT NULL,
  `ip_mac` varchar(255) DEFAULT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  `wallet_amount` float(8,2) NOT NULL DEFAULT '0.00',
  `assign_jobs` int(1) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `otp_verified` int(1) NOT NULL DEFAULT '0',
  `email_verified` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  KEY `sub_category_id` (`sub_category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1024 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`user_id`, `sub_category_id`, `user_name`, `access_token`, `password`, `logged_from`, `last_logged_on`, `is_internal`, `lattitude`, `longitude`, `ip_mac`, `active`, `wallet_amount`, `assign_jobs`, `created_at`, `updated_at`, `updated_by`, `otp_verified`, `email_verified`) VALUES
(1001, 1, 'dkm', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '319c2e75cd00b2634c44c507af4aa25fa608d4fe', 'mobile', 1553126984, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1543738929, 0, 0, 1, 1),
(1002, 3, 'krv', '54c67ff6940e3d5c3a56098ceaf8ce0b7fe994e0', '319c2e75cd00b2634c44c507af4aa25fa608d4fe', 'mobile', 1548743012, 0, 0, 0, 'E0-2A-82-43-97-66', 1, 0.00, NULL, 1543822020, 1551033000, 1001, 0, 0),
(1003, 2, 'Aravinth', '54c67ff6940e3d5c3a56098ceaf8ce0b7fe994e0', '7c4a8d09ca3762af61e59520943dc26494f8941b', 'mobile', NULL, 0, 0, 0, 'E0-2A-82-43-97-66', 1, 0.00, NULL, 1543822020, 1551033000, 1001, 0, 0),
(1004, 2, 'mdk', '54c67ff6940e3d5c3a56098ceaf8ce0b7fe994e0', '4b0abdf237c72dd2132d5bedc52e49d246822b58', 'mobile', 1548974231, 0, NULL, NULL, NULL, 1, 0.00, NULL, 1549017065, 1551033000, 1001, 0, 0),
(1006, 4, 'arun', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8cb2237d0679ca88db6464eac60da96345513964', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552329000, 0, 0, 0, 0),
(1011, 4, 'hello', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8cb2237d0679ca88db6464eac60da96345513964', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1012, 7, 'ambani11', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8cb2237d0679ca88db6464eac60da96345513964', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1013, 1, '', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1014, 1, '', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1015, 2, 'aaa11', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8cb2237d0679ca88db6464eac60da96345513964', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1016, 2, 'testsss', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '85136c79cbf9fe36bb9d05d0639c70c265c18d37', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1017, 2, 'airtel', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8cb2237d0679ca88db6464eac60da96345513964', 'web', 1551941789, 1, NULL, NULL, NULL, 0, 0.00, NULL, 1552415400, 1552933800, 1001, 0, 0),
(1018, 6, 'basic', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8cb2237d0679ca88db6464eac60da96345513964', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1019, 2, '', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8cb2237d0679ca88db6464eac60da96345513964', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1020, 2, '', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8cb2237d0679ca88db6464eac60da96345513964', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1021, 2, 'last test', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8cb2237d0679ca88db6464eac60da96345513964', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1022, 4, 'ghighi', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '3458ea4f9cb3497a21894befbcf070cf59cbba1d', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0),
(1023, 3, 'empty1', 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8cb2237d0679ca88db6464eac60da96345513964', 'web', 1551941789, 1, NULL, NULL, NULL, 1, 0.00, NULL, 1552415400, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `user_details`
--

DROP TABLE IF EXISTS `user_details`;
CREATE TABLE IF NOT EXISTS `user_details` (
  `details_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `address_line_one` varchar(255) DEFAULT NULL,
  `address_line_two` varchar(255) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `gstin` varchar(75) DEFAULT NULL,
  `phone` bigint(20) NOT NULL,
  `pincode` int(10) DEFAULT NULL,
  `alternate_phone` bigint(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `is_default` int(1) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`details_id`),
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `user_details`
--

INSERT INTO `user_details` (`details_id`, `user_id`, `name`, `address_line_one`, `address_line_two`, `city`, `state`, `country`, `gstin`, `phone`, `pincode`, `alternate_phone`, `email`, `is_default`, `active`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(1, 1001, 'dkm', '#18, Sannathy Street, Meenakshi Amman Nagar', 'Alwarthiru Nagar', 'Chennai', 'Tamilnadu', 'India', '33BZZPS9908Q1ZV', 9962090355, 600087, 0, 'dinesh@yahoo.com', 1, 1, 1543738929, 1001, 0, 0),
(2, 1002, 'Vinith', 'TEST', '', 'Chennai', 'Tamilnadu', 'India', '', 9003031003, 607203, 8745612301, 'Vinith@avthedigiworks.com', 1, 1, 1543822142, 1002, 0, 0),
(3, 1003, 'Aravinth', '', '', 'Chennai', 'Tamilnadu', 'India', '', 9003031003, 607201, 0, 'Aravinth@gmail.com', 1, 1, 1543822142, 1003, 0, 0),
(4, 1004, 'James Carmen', '#30A, Sannthi street,Meenakshi Amman Nagar', 'Alwarthiru Nagar', 'Chennai', 'Tamilnadu', 'India', NULL, 9597207343, 607200, 9597207343, 'dinesh@sitestorms.com', 1, 1, 1549017065, 1004, 1549274992, 1004),
(9, 1006, 'arun', 'address ', 'address ', 'chennai', 'dont know', 'xxxx', NULL, 9003585477, 607202, 8072647542, 'arun@gmail.com', 0, 1, 1552329000, 1006, 0, 0),
(12, 1011, 'hello', 'address', 'address', 'chennai', 'tn', 'ind', NULL, 9003585477, 607202, 8072647542, 'hello@gmail.com', 0, 1, 1552415400, 1011, 0, 0),
(13, 1012, 'ambani11', 'goa 00', 'address 22', 'goa11', 'mp11', 'ind11', NULL, 9597960011, 505111, 9600710000, 'ambani11@gmail.com1', 0, 1, 1552415400, 1012, 0, 0),
(14, 1015, 'aaa11', 'asds', 'asds', 'Chennai11', 'ap', 'ind1', NULL, 9003585477, 607000, 9638527410, 'adin@gmail.cmo', 0, 1, 1552415400, 1015, 0, 0),
(15, 1016, 'testsss', 'asdasd', 'asdasd', 'dasdasd', 'ap', 'ind1', NULL, 9874563210, 505100, 8072564700, 'dinesh@gmail.com', 0, 1, 1552415400, 1016, 0, 0),
(16, 1017, 'airtel', 'saadas', 'saadas', 'Chennai11', 'ss', 'ind00', NULL, 9325874112, 607202, 6654864651, 'airtel@gmail.com', 0, 1, 1552415400, 1017, 0, 0),
(17, 1018, 'basic', 'aaaaaaaaaaaaaaa', 'aaaaaaaaaaaaaaa', 'goa', 'ap', 'ind00', NULL, 9874563210, 505100, 8745612301, 'dinesh@gmail.com', 0, 1, 1552415400, 1018, 0, 0),
(18, 1019, 'hello', 'aaaaaaaaaaaa', 'aaaaaaaaaaaa', 'Chennai11', 'ap', 'ind00', NULL, 9874563210, 505100, 8072564700, 'dfgdfg@fdgdfg', 0, 1, 1552415400, 1019, 0, 0),
(19, 1020, 'sugu', 'aaaaaaaaaaaaa', 'aaaaaaaaaaaaa', 'Chennai11', 'ap', 'ind00', NULL, 9874563210, 607210, 8072564700, 'dinesh@gmail.com', 0, 1, 1552415400, 1020, 0, 0),
(20, 1021, 'last test', 'ssssssssss', 'ssssssssss', 'goa', 'mp', 'ind00', NULL, 9638520741, 505100, 7410852096, 'last@gmails.com', 0, 1, 1552415400, 1021, 0, 0),
(21, 1023, 'empty1', 'kumar arun ', 'kumar arun ', 'chennai', 'state', 'country', NULL, 9633254541, 607202, 9865744155, 'empty@g.com', 0, 1, 1552415400, 1023, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `user_menus`
--

DROP TABLE IF EXISTS `user_menus`;
CREATE TABLE IF NOT EXISTS `user_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `menu_id` (`menu_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `user_ratings`
--

DROP TABLE IF EXISTS `user_ratings`;
CREATE TABLE IF NOT EXISTS `user_ratings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `rating` varchar(50) NOT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `comments` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `user_ratings`
--

INSERT INTO `user_ratings` (`id`, `user_id`, `rating`, `created_at`, `created_by`, `updated_at`, `updated_by`, `comments`) VALUES
(1, 1002, '3.5', 1543824087, 3, NULL, NULL, 'Good');

-- --------------------------------------------------------

--
-- Table structure for table `user_rights`
--

DROP TABLE IF EXISTS `user_rights`;
CREATE TABLE IF NOT EXISTS `user_rights` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rights_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rights_id` (`rights_id`),
  KEY `role_id` (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `user_rights`
--

INSERT INTO `user_rights` (`id`, `rights_id`, `role_id`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(1, 1, 1, 1543738929, 1, NULL, NULL),
(2, 4, 1, 1543738929, 1, NULL, NULL),
(3, 2, 1, 1543738929, 1, NULL, NULL),
(4, 3, 1, 1543738929, 1, NULL, NULL),
(5, 5, 1, 1543738929, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `user_roles`
--

DROP TABLE IF EXISTS `user_roles`;
CREATE TABLE IF NOT EXISTS `user_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `created_at` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `role_id` (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `user_roles`
--

INSERT INTO `user_roles` (`id`, `user_id`, `role_id`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(1, 1001, 1, 1543738929, 1001, NULL, NULL),
(2, 1002, 2, 1543738929, 1002, NULL, NULL),
(3, 1003, 2, 1543738929, 1003, NULL, NULL),
(4, 1004, 2, 1549017065, 1004, NULL, NULL),
(5, 1006, 2, 1552329000, 1006, NULL, NULL),
(9, 1011, 2, 1552415400, 1011, NULL, NULL),
(10, 1012, 1, 1552415400, 1012, NULL, NULL),
(11, 1015, 2, 1552415400, 1015, NULL, NULL),
(12, 1016, 3, 1552415400, 1016, NULL, NULL),
(13, 1017, 3, 1552415400, 1017, NULL, NULL),
(14, 1018, 3, 1552415400, 1018, NULL, NULL),
(15, 1019, 3, 1552415400, 1019, NULL, NULL),
(16, 1020, 2, 1552415400, 1020, NULL, NULL),
(17, 1021, 2, 1552415400, 1021, NULL, NULL),
(18, 1022, 2, 1552415400, 1022, NULL, NULL),
(19, 1023, 4, 1552415400, 1023, NULL, NULL);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `app_images`
--
ALTER TABLE `app_images`
  ADD CONSTRAINT `FK_APP_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `child_categories`
--
ALTER TABLE `child_categories`
  ADD CONSTRAINT `FK_PARENT_ID` FOREIGN KEY (`parent_id`) REFERENCES `parent_categories` (`category_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `child_category_parameters`
--
ALTER TABLE `child_category_parameters`
  ADD CONSTRAINT `FN_PARAMETER_TITLE_ID` FOREIGN KEY (`title_id`) REFERENCES `parameter_title` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `jobs`
--
ALTER TABLE `jobs`
  ADD CONSTRAINT `FK_JOB_STATUS_ID` FOREIGN KEY (`status_id`) REFERENCES `status` (`status_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_JOB_TRANSACTION_ID` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`transaction_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_JOB_USER_ID` FOREIGN KEY (`assigned_to`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `job_requests`
--
ALTER TABLE `job_requests`
  ADD CONSTRAINT `FK_JOB_POSTED_DY` FOREIGN KEY (`posted_by`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_JOB_USER_DETAILS` FOREIGN KEY (`details_id`) REFERENCES `user_details` (`details_id`);

--
-- Constraints for table `my_calendar`
--
ALTER TABLE `my_calendar`
  ADD CONSTRAINT `FK_SP_ID` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `parameter_title`
--
ALTER TABLE `parameter_title`
  ADD CONSTRAINT `FK_PT_SERVICE` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `services`
--
ALTER TABLE `services`
  ADD CONSTRAINT `FK_CHILD_CAT_SERVICE` FOREIGN KEY (`child_id`) REFERENCES `child_categories` (`child_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `service_provider_job_temp`
--
ALTER TABLE `service_provider_job_temp`
  ADD CONSTRAINT `FK_JOB_TEMP_REQ_ID` FOREIGN KEY (`request_id`) REFERENCES `job_requests` (`request_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_JOB_TEMP_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `subscriptions`
--
ALTER TABLE `subscriptions`
  ADD CONSTRAINT `FK_SUBS_PLAN_ID` FOREIGN KEY (`plan_id`) REFERENCES `plans` (`plan_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_SUBS_TRANS_ID` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`transaction_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_SUBS_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `transactions`
--
ALTER TABLE `transactions`
  ADD CONSTRAINT `FK_TRANS_USER` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_ibfk_1` FOREIGN KEY (`sub_category_id`) REFERENCES `child_categories` (`child_id`);

--
-- Constraints for table `user_details`
--
ALTER TABLE `user_details`
  ADD CONSTRAINT `FN_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `user_menus`
--
ALTER TABLE `user_menus`
  ADD CONSTRAINT `FK_MENU_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_USER_MENU` FOREIGN KEY (`menu_id`) REFERENCES `menus` (`menu_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `user_ratings`
--
ALTER TABLE `user_ratings`
  ADD CONSTRAINT `FK_RATING_USER` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `user_rights`
--
ALTER TABLE `user_rights`
  ADD CONSTRAINT `FK_RIGHT_ID` FOREIGN KEY (`rights_id`) REFERENCES `rights` (`right_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_RIGHT_ROLE` FOREIGN KEY (`role_id`) REFERENCES `roles` (`role_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `user_roles`
--
ALTER TABLE `user_roles`
  ADD CONSTRAINT `FK_ROLE_USER` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_USER_ROLE` FOREIGN KEY (`role_id`) REFERENCES `roles` (`role_id`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
