<?php 
    require_once('includes/check-login.php');
    require_once('includes/header.php'); 
    require_once('includes/menu.php'); 
    require_once('includes/config.php'); 
$tablename="services";	
?>
        <!-- Datatable CSS -->
        <link href='data_tables/datatables.min.css' rel='stylesheet' type='text/css' />        

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">                
                    <small><a href="javascript:void(0);" class="newService"><i class="fa fa-plus"></i> Services</a></small>                    
                    <ol class="breadcrumb">
                        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>                    
                        <li class="active"><a href="services.php">Services</a></li>           
                    </ol>                
            </section>

            <!-- Main content -->
            <section class="content">                
                <!-- Default box -->
                <div class="box box-form">
                    <div class="box-header with-border">
                        <h3 class="box-title">Services</h3>
						<?php if(isset($_SESSION[$tablename."succ_msg"])) {?>
                 <div class="alert alert-success">
                 <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
                 <?php echo $_SESSION[$tablename."succ_msg"];  unset($_SESSION[$tablename."succ_msg"]);?>
                 </div>
                <?php }?>   
                <?php if(isset($_SESSION[$tablename."err_msg"])) {?>
                <div class="alert alert-success">
                <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
                <?php echo $_SESSION[$tablename."err_msg"]; unset($_SESSION[$tablename."err_msg"]);?>
                </div>
               <?php }?>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
                                <i class="fa fa-minus"></i></button>
                            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
                                <i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <div class="box-body">    
                        <!-- Table -->
                        <table id='Services' class='display dataTable table table-bordered table-hover'>
                            <thead>
                            <tr>
                                <th>Service Name</th>                                              
                                <th>Child Category</th>                               
                                <th>Default Price</th>
                                <th>Minimum Price</th>
                                <th>Offer Price</th>                               
                                <th>Best Seller</th>                               
                                <th>Discount</th>                               
                                <th>Active</th>                                                              
                                <th>Edit</th> 
                                <th>Delete</th> 
                            </tr>
                            </thead>                
                        </table>

                    </div>
                    
                    <!-- /.box-footer-->                    
                </div>
                <!-- /.box -->

            </section>
            <!-- /.content -->                                        
        </div>
        <!-- /.content-wrapper -->        

        <div class="modal fade" id="serviceModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="serviceTitle"></h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12 message"></div>
                            <form role="form" id="serviceForm">                                
                                <div class="col-md-12">
                                    <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Child Category</label>
                                        <br>
                                        <select class="form-control" id="child_id" name="child_id" >
                                            <option value="-1">---Select---</option>
                                            <?php
                                            $csql = "SELECT child_id, sub_category_name FROM child_categories WHERE active = 1";
                                            $cexe = mysqli_query( $con, $csql );
                                            ?>                                        
                                            <?php while( $crows = mysqli_fetch_assoc( $cexe ) ) { ?>
                                                <option value="<?php echo $crows['child_id']; ?>"><?php echo $crows['sub_category_name']; ?></option>
                                            <?php } ?>                                        
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label>Service Name</label>
                                        <br>
                                        <input type="hidden" id="service_id" name="service_id" value="" />
                                        <input type="text" class="form-control" id="service_name" name="service_name" placeholder="Service Name" value="" />
                                    </div>                                                                        
                                    <div class="form-group">
                                        <label>Default Price</label>
                                        <br>
                                        <input type="text" class="form-control" id="default_price" name="default_price" placeholder="Default Price" value="" />
                                    </div>

                                    <div class="form-group">
                                        <label>Active</label>
                                        <br>
                                        <select id="active" name="active" class="form-control">
                                            <option value="-1">-- Active --</option>
                                            <option value="1" selected="selected">Active</option>
                                            <option value="0">Inactive</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label>Service Image</label>
                                        <br>
                                        <input type="file" class="form-control" id="service_img" name="service_img" />
                                        <input type="hidden" value="" id="old_image" name="old_image" />
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>Offer Price</label>
                                        <br>
                                        <input type="text" class="form-control" id="offer_price" name="offer_price" placeholder="Offer Price" value="" />
                                    </div>

                                    <div class="form-group">
                                        <label>Minimum Price</label>
                                        <br>
                                        <input type="text" class="form-control" id="min_visit_price" name="min_visit_price" placeholder="Offer Price" value="" />
                                    </div>

                                    <div class="form-group">
                                        <label>Discount</label>
                                        <br>
                                        <input type="text" class="form-control" id="discount" name="discount" placeholder="Discount Percentage" value="" />
                                    </div>

                                    <div class="form-group">
                                        <label>Is Best Seller?</label>
                                        <br>
                                        <select id="is_best_seller" name="is_best_seller" class="form-control">
                                            <option value="-1">---Select---</option>
                                            <option value="1">Yes</option>
                                            <option value="0" selected="selected">No</option>
                                        </select>
                                    </div>

                                    
                                </div>
                            </div>
                                <div class="col-xs-12">
                                    <button type="button" class="btn btn-primary" id="serviceBtn">Save</button>
                                    <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<script src="js/common.js"></script>     
<script src="js/services/script.js"></script>     
<?php require_once('includes/footer.php'); ?>