/*
* ------------------------------------------------------------------------------
* Users js file 
* Includes scripts for services management
* Author Dinesh Kumar Muthukrishnan 
* -------------------------------------------------------------------------------
*/
/*
* Clear message 
*/
$(document).ready(function() {
	$('.message').html('');	

	$('#Services').DataTable({
        'processing': true,
        'serverSide': true,
        'serverMethod': 'post',
        'ajax': {
            'url':'grid-services.php'
        },
        "columnDefs": [
        	{"className": "dt-center", "targets": [-1,-2] }
      	],
        'columns': [
        	{ data: 'service_name' },            
        	{ data: 'child_category' },            
            { data: 'default_price' },            
            { data: 'min_visit_price' },            
            { data: 'offer_price' },            
            { data: 'is_best_seller' },
            { data: 'discount' },
            { data: 'active' },                        
            { data: 'edit' },                        
            { data: 'delete' },                        
        ]
    });     
});
/*
* Primary Category click event handler
*/
$(document).on('click','#serviceBtn',function() {
	var default_price    = $('#default_price').val();	
	var offer_price      = $('#offer_price').val();		
	var name             = $('#service_name').val();	
	var active           = $('#active').val();	
	var is_best_seller   = $('#is_best_seller').val();	
	var min_visit_price  = $('#min_visit_price').val();	
	var formData         = new FormData( $('#serviceForm')[0] );	
	var message          = '';
	var flag             = 1 ;

	if( name == "" ){
		message = "Please enter Service Name";
		flag = 0;
		$('#service_name').focus();
		setNotification('error', message, 'red');
	}	
	
	if ( active == "-1" ){
		message = "Please select active";
		flag = 0;
		$('#active').focus();
		setNotification('error', message, 'red');
	}

	if ( child_id == "-1" ){
		message = "Please select Child Category";
		flag = 0;
		$('#active').focus();
		setNotification('error', message, 'red');
	}

	if ( is_best_seller == "-1" ){
		message = "Please select Best Seller";
		flag = 0;
		$('#is_best_seller').focus();
		setNotification('error', message, 'red');
	}

	if ( default_price == "" ){
		message = "Please enter default price";
		flag = 0;
		$('#default_price').focus();
		setNotification('error', message, 'red');
	}
	if ( flag == 1 ){
		$.ajax({
			url  : serverUrl+'PostServices.php',
			data : formData,
			method : 'POST',
			processData: false,
    		contentType: false,
			success: function( response ) {
				//alert(response);
				var objData = JSON.parse( response );
				message = objData.data;
				if( objData.code == 200 ){					
					setNotification( 'success', message, 'green' );
	                setTimeout(function() {
	                    window.location.reload(); }, 2500 );
			    }
			   	if( objData.code == 404 || objData.code == 405 ){	       	
		   			message = objData.data;
		   			setNotification( 'success', message, 'red' );
	                setTimeout(function() {
	                    window.location.reload(); }, 2500 );
		   		}	
		    },
		    error: function () {
		        if( response.code == 401 ){
		       		window.location.replace('/');		       	
		        }
		        $('.message').addClass('error').html(message);
		    } 
		});
	}

});

/*
* opens modal on click event handler
*/
$(document).on('click','.newService',function() {
	$('#serviceModal').modal('show');
	$('#serviceTitle').html('New Service');
	$('#service_name').val();
	$('#child_id').val('');
	$('#offer_price').val('');
	$('#default_price').val('');
	$('#is_best_seller').val('');
	$('#discount').val('');
	$('#active').val('');
	$('#old_image').val('');
});


/*
* opens modal on click event handler
*/
$(document).on('click','.edit',function() {
	$('#serviceModal').modal('show');
	//loadChildCategories();
	var service        = $(this).attr('data-service_id');
	var child_id       = $(this).attr('data-child_id');
	var dprice         = $(this).attr('data-default_price');
	var oprice         = $(this).attr('data-offer_price');
	var is_best_seller = $(this).attr('data-is_best_seller');
	var discount       = $(this).attr('data-discount');
	var active         = $(this).attr('data-active');
	var service_image  = $(this).attr('data-service_image');
	var service_name   = $(this).attr('data-service_name');
	var min_visit_price= $(this).attr('data-min-price');
	
	/* adding value to form */
	$('#min_visit_price').val(min_visit_price);
	$('#service_id').val(service);
	$('#service_name').val(service_name);
	$('#child_id').val(child_id);
	$('#offer_price').val(oprice);
	$('#default_price').val(dprice);
	$('#is_best_seller').val(is_best_seller);
	$('#discount').val(discount);
	$('#active').val(active);
	$('#old_image').val(service_image);
	$('#serviceTitle').html(service_name);
});

/*
* Child Categories
* returns child categories
*/
function loadChildCategories() {
	var htm = '';
	$.ajax({
		url : 'child_categories.php',
		method: 'POST',
		data: { 'type' : 'child' },
		success: function( response ) {
			console.log( response );
			if( objData.code == 200 ){					
				var objData = JSON.parse( objData.data );		
				htm += '<option value ="-1">---Select---</option>';
				$.each( objData, function( index, obj ){
					htm += '<option value ="'+obj.id+'">'+obj.name+'</option>';
				});
				$('#child_id').html( htm );	
			}
			if( objData.code == 404 || objData.code == 405 ){	       	
		   		message = objData.data;
		   		setNotification( 'error', message, 'red' );	    
		   	}            
		}, error: function() {
			message = 'Call server failed';
			setNotification( 'error', message, 'red' );
		}
	});
}