
/*
* ------------------------------------------------------------------------------
* Secondary Category js file 
* Includes scripts for Secondary category management
* Author Dinesh Kumar Muthukrishnan 
* -------------------------------------------------------------------------------
*/

/*
* Clear message 
*/
$(document).ready(function() {
	$('.message').html('');	

	$('#SecondaryCategory').DataTable({
        'processing': true,
        'serverSide': true,
        'serverMethod': 'post',
        'ajax': {
            'url':'grid-secondary-categories.php'
        },
        "columnDefs": [
        	{"className": "dt-center", "targets": [-1,-2] }
      	],
        'columns': [
            { data: 'category_name' },
            { data: 'sub_category_name' },            
            { data: 'active' },
            { data: 'category_img_path' },
            { data: 'created_at' },
            { data: 'edit' },
            { data: 'delete' },
        ]
    });     
});


/*
* Primary Category click event handler
*/
$(document).on('click','#CategoryBtn',function() {
	var primary_category   = $('#primary_category').val();
	var secondary_category = $('#secondary_category').val();
	var sort_order         = $('#sort_order').val();
	var active             = $('#active').val();	
	var formData           = new FormData( $('#categoryForm')[0] );	
	var message            = '';
	var flag               = 1 ;

	if( primary_category == "-1" ){
		message = "Please enter Primary Category Name";
		flag = 0;
		$('#primary_category').focus();
		$('.message').addClass('error').html(message);
	}

	if( secondary_category == "" ){
		message = "Please enter Secondary Category Name";
		flag = 0;
		$('#secondary_category').focus();
		$('.message').addClass('error').html(message);
	}	

	if( sort_order == "" ){
		message = "Please enter sort order";
		flag = 0;
		$('#sort_order').focus();
		$('.message').addClass('error').html(message);
	}

	if ( active == "-1" ){
		message = "Please enter password";
		flag = 0;
		$('#active').focus();
		$('.message').addClass('error').html(message);
	}

	if ( flag == 1 ){
		$.ajax({
			url  : serverUrl+'PostSecondaryCategory.php',
			data : formData,
			method : 'POST',
			processData: false,
    		contentType: false,
			success: function( response ) {
				console.log(response);
				var objData = JSON.parse( response );
				if( objData.code == 200 ){			
					message = objData.data;		
					setNotification( 'success', message, 'red' );
	                setTimeout(function() {
	                    window.location.href = objData.url+'.php'; }, 2500 );		       		
			    }
			   	if( objData.code == 404 || objData.code == 405 ){	       	
		   			message = objData.data;
		   			setNotification( 'error', message, 'red' );
	                setTimeout(function() {
	                    window.location.href = objData.url+'.php'; }, 2500 );
		   		}	
		    },
		    error: function () {
		        if( response.code == 401 ){
		       		window.location.replace('/');		       	
		        }
		        $('.message').addClass('error').html(message);
		    } 
		});
	}

});

/*
* opens modal on click event handler
*/
$(document).on('click','.newCat',function() {
	$('#categoryModal').modal('show');
	$('#categoryTitle').html('New Secondary Category');
});

$(document).on( 'click', '.edit', function(){
    var id         		 		= $(this).attr('data-id');
    var primaryCategory 		= $(this).attr('data-primaryCategory');
    var subCategoryName 		= $(this).attr('data-subCategoryName');
    var childCategoryImgPath  	= $(this).attr('data-childCategoryImgPath');
    var status     	 	 		= $(this).attr('data-status');
    //console.log( id +'-------'+ primaryCategory +'-------'+ subCategoryName +'-------'+ childCategoryImgPath +'-------'+status );

    $('#descriptionTitleModal').modal('show');
    $('#id').val(id);    
    $('#subCat_name').val(subCategoryName);
    $('#old_img_name').val(childCategoryImgPath);
    $('#status').val(status);
    $('#primary_name').val(primaryCategory);
})
/*  update description title*/
$(document).on( 'click', '.updateSecCat', function(){
   var desc_name = $('#subCat_name').val();
   var flag=1
            if ( desc_name == "" ) {
                 message = "Please Enter Your Category Name";
                 flag = 0;
                 $('.message').addClass('error').html(message);
                 $("#desc_name").focus();
             }
/*		if(flag==1){
			var type = "secondaryCategory";
		    $.get("edit.php?type="+type,$( "#editSecondaryCat" ).serialize(),function(data){
		    	alert(data)
				setTimeout(function(){
					window.location.replace("secondary-category.php");
				}, 500);
    		});
		}
*/
if( flag == 1) {
    var formData = new FormData();
	formData.append( 'type', 'secondaryCategory' );
	
    formData.append( 'id', $('#id').val() );
    formData.append( 'primary_name', $('#primary_name').val() );
    formData.append( 'subCat_name', $('#subCat_name').val() );
    formData.append( 'old_img', $('#old_img').val() );
    formData.append( 'status', $('#status').val() );
    formData.append( 'desc_name', desc_name );
    formData.append( 'img_cat', $('#img_cat')[0].files[0] );
    $.ajax({
			url  : 'edit.php',
			data : formData,
			method : 'POST',
			processData: false,
    		contentType: false,
			success: function( response ) {
 				console.log(response);
				var objData = JSON.parse( response );
				if( objData.code == 200 ) {
					message = objData.data;
					setNotification( 'success', message, 'green' );
	                setTimeout(function() {
	                    window.location.href = 'secondary-category.php'; }, 2500 );		       		
			    }
			   	if( objData.code == 404 || objData.code == 405 ) {	       	
			   		message = objData.data;
		   			setNotification( 'error', message, 'red' );
	                setTimeout(function() {
	                    window.location.href = 'secondary-category.php'; }, 2500 );			   		
		   		}	
		    },
		    error: function () {
		        if( response.code == 401 ){
		       		window.location.replace('/');		       	
		        }
		        $('.message').addClass('error').html(message);
		    } 
		});
}
	});
