
/*
* ------------------------------------------------------------------------------
* Roles js file 
* Includes scripts for roles management
* Author Dinesh Kumar Muthukrishnan 
* -------------------------------------------------------------------------------
*/

/*
* Clear message 
*/
$(document).ready(function() {
	$('.message').html('');	

	$('#Roles').DataTable({
        'processing': true,
        'serverSide': true,
        'serverMethod': 'post',
        'ajax': {
            'url':'grid-roles.php'
        },
        "columnDefs": [
        	{"className": "dt-center", "targets": [-1,-2] }
      	],
        'columns': [
            { data: 'role_name' },            
            { data: 'active' },            
            { data: 'created_at' },
            { data: 'edit' },
            { data: 'delete' },
        ]
    });     
});


/*
* Primary Category click event handler
*/
$(document).on('click','#roleBtn',function() {
	var role_name        = $('#role_name').val();	
	var active           = $('#active').val();	
	var formData         = new FormData( $('#roleForm')[0] );	
	var message          = '';
	var flag             = 1 ;

	if( role_name == "" ){
		message = "Please enter RoleName";
		flag = 0;
		$('#role_name').focus();
		$('.message').addClass('error').html(message);
	}	
	
	if ( active == "-1" ){
		message = "Please enter password";
		flag = 0;
		$('#active').focus();
		$('.message').addClass('error').html(message);
	}

	if ( flag == 1 ){
		$.ajax({
			url  : serverUrl+'PostRoles.php',
			data : formData,
			method : 'POST',
			processData: false,
    		contentType: false,
			success: function( response ) {
				console.log(response);
				var objData = JSON.parse( response );
				if( objData.code == 200 ){		
					message = objData.data;			
					setNotification( 'success', message, 'green' );
	                setTimeout(function() {
	                    window.location.href = objData.url+'.php'; }, 2500 );		       		
			    }
			   	if( objData.code == 404 || objData.code == 405 ) {	       	
		   			message = objData.data;
		   			setNotification( 'error', message, 'red' );
	                setTimeout(function() {
	                    window.location.href = objData.url+'.php'; }, 2500 );
				}	
			
		    },
		    error: function () {
		        if( response.code == 401 ){
		       		window.location.replace('/');		       	
		        }
		        $('.message').addClass('error').html(message);
		    } 
		});
	}

});

/*
* opens modal on click event handler
*/
$(document).on('click','.newRole',function() {
	$('#roleModal').modal('show');
	$('#roleTitle').html('New Role');
	$('#role_name').val('');
	$('.metaInfo').html('');
});

/*
* opens modal on click event handler
*/
$(document).on('click','.edit',function() {
	$('#roleModal').modal('show');
	var id           = $(this).attr('data-id');  
	var name         = $(this).attr('data-name');    
	var identifier   = $(this).attr('data-identifier');   
    var table        = $(this).attr('data-table');    
    var call_back    = $(this).attr('data-call_back');    
    var extension    = $(this).attr('data-extension'); 
    var active       = $(this).attr('data-active'); 
    var htm = '';
    htm += '<input type="hidden" class="form-control" id="rId" name="rId" value="" />';
    htm += '<input type="hidden" name ="identifier" value="'+identifier+'"/>';
    htm += '<input type="hidden" name ="table" value="'+table+'"/>';
    htm += '<input type="hidden" name ="call_back" value="'+call_back+'"/>';
    htm += '<input type="hidden" name ="extension" value="'+extension+'"/>';
    $('.metaInfo').html(htm);
	$('#roleTitle').html('Details of ' + name );
	$('#role_name').val(name);
	$('#active').val(active);
	$('#rId').val(id);
});