
/*
* ------------------------------------------------------------------------------
* Primary Category js file 
* Includes scripts for primary category management
* Author Dinesh Kumar Muthukrishnan 
* -------------------------------------------------------------------------------
*/

/*
* Clear message 
*/
$(document).ready(function() {
	$('.message').html('');	

	$('#PrimaryCategory').DataTable({
        'processing': true,
        'serverSide': true,
        'serverMethod': 'post',
        'ajax': {
            'url':'grid-primary-categories.php'
        },
        "columnDefs": [
        	{"className": "dt-center", "targets": [-1,-2] }
      	],
        'columns': [
            { data: 'category_name' },
            { data: 'sort_order' },
            { data: 'active' },
            { data: 'category_img_path' },
            { data: 'created_at' },
            { data: 'edit' },
            { data: 'delete' },
        ]
    });     
});


/*
* Primary Category click event handler
*/
$(document).on('click','#CategoryBtn',function() {
	var category_name    = $('#category_name').val();
	var sort_order       = $('#sort_order').val();
	var active           = $('#active').val();	
	var formData         = new FormData( $('#categoryForm')[0] );	
	var message          = '';
	var flag             = 1 ;

	if( category_name == "" ){
		message = "Please enter Primary Category Name";
		flag = 0;
		$('#category_name').focus();
		$('.message').addClass('error').html(message);
	}	

	if( sort_order == "" ){
		message = "Please enter sort order";
		flag = 0;
		$('#sort_order').focus();
		$('.message').addClass('error').html(message);
	}

	if ( active == "-1" ){
		message = "Please enter password";
		flag = 0;
		$('#active').focus();
		$('.message').addClass('error').html(message);
	}

	if ( flag == 1 ){
		$.ajax({
			url  : serverUrl+'PostPrimaryCategory.php',
			data : formData,
			method : 'POST',
			processData: false,
    		contentType: false,
			success: function( response ) {
				console.log(response);
				var objData = JSON.parse( response );
				if( objData.code == 200 ) {
					message = objData.data;
					setNotification( 'success', message, 'red' );
	                setTimeout(function() {
	                    window.location.href = objData.url+'.php'; }, 2500 );		       		
			    }
			   	if( objData.code == 404 || objData.code == 405 ) {	       	
			   		message = objData.data;
		   			setNotification( 'error', message, 'red' );
	                setTimeout(function() {
	                    window.location.href = objData.url+'.php'; }, 2500 );			   		
		   		}	
		    },
		    error: function () {
		        if( response.code == 401 ){
		       		window.location.replace('/');		       	
		        }
		        $('.message').addClass('error').html(message);
		    } 
		});
	}
});

/*
* opens modal on click event handler
*/
$(document).on('click','.newCat',function() {
	$('#categoryModal').modal('show');
	$('#categoryTitle').html('New Primary Category');
});
/*
* edit modal popup
* returns description details with matching record
* @params user_id
*/
$(document).on( 'click', '.edit', function(){
    var id         	 = $(this).attr('data-id');
    var categoryName = $(this).attr('data-categoryName');
    var imagePath  	 = $(this).attr('data-imgPath');
    var newImagePath = $(this).attr('data-newImgPath');
    var sortOrder  	 = $(this).attr('data-order');
    var status     	 = $(this).attr('data-status');

    $('#pcEditModal').modal('show');
    $('#id').val(id);
    $('#cat_name').val(categoryName);
    $('#img_cat').val(newImagePath);
    $('#old_img').val(imagePath);
    $('#order').val(sortOrder);
    $('#status').val(status);
})
/*  update script*/
$(document).on( 'click', '.updatePrimaryCategory', function(){
    var cat_name     = $('#cat_name').val();
    var sort_order   = $('#order').val();
    var flag=1
    if ( cat_name == "" ) {
        message = "Please Enter Your Category Name";
        flag = 0;
        $('.message').addClass('error').html(message);
        $("#cat_name").focus();
    }
    if ( sort_order == "" ) {
        message = "Please Enter Your Sort Order";
        flag = 0;
        $('.message').addClass('error').html(message);
        $("#order").focus();
    }
if( flag == 1) {
    var formData = new FormData();
    formData.append( 'id', $('#id').val() );
    formData.append( 'type', 'PrimaryCategory' );
    formData.append( 'old_img', $('#old_img').val() );
    formData.append( 'cat_name', cat_name );
    formData.append( 'sort_order', $('#sort_order').val() );
    formData.append( 'status', $('#status').val() );
    formData.append( 'img_cat', $('#img_cat')[0].files[0] );
    $.ajax({
			url  : 'edit.php',
			data : formData,
			method : 'POST',
			processData: false,
    		contentType: false,
			success: function( response ) {
 				console.log(response);
				var objData = JSON.parse( response );
				if( objData.code == 200 ) {
					message = objData.data;
					setNotification( 'success', message, 'green' );
	                setTimeout(function() {
	                    window.location.href = 'primary-category.php'; }, 2500 );		       		
			    }
			   	if( objData.code == 404 || objData.code == 405 ) {	       	
			   		message = objData.data;
		   			setNotification( 'error', message, 'red' );
	                setTimeout(function() {
	                    window.location.href = 'primary-category.php'; }, 2500 );			   		
		   		}	
		    },
		    error: function () {
		        if( response.code == 401 ){
		       		window.location.replace('/');		       	
		        }
		        $('.message').addClass('error').html(message);
		    } 
		});
}
});
