/*
* ------------------------------------------------------------------------------
* Category description title js file 
* Includes scripts for primary category management
* Author Dinesh Kumar Muthukrishnan 
* -------------------------------------------------------------------------------
*/

/*
* Clear message 
*/
$(document).ready(function() {
	$('.message').html('');	

	$('#CategoryDesc').DataTable({
        'processing': true,
        'serverSide': true,
        'serverMethod': 'post',
        'ajax': {
            'url':'grid-description-titles.php'
        },
        "columnDefs": [
        	{"className": "dt-center", "targets": [-1,-2] }
      	],
        'columns': [
            { data: 'service_name' },
            { data: 'title' },
            { data: 'sort_order' },
            { data: 'active' },            
            { data: 'created_at' },
            { data: 'edit' },
            { data: 'delete' },
        ]
    });     
});


/*
* Category description title click event handler
*/
$(document).on('click','#CategoryTitleBtn',function() { 
	var description_title= $('#description_title').val();
	var service_name     = $('#service_name').val();
	var sort_order       = $('#sort_order').val();
	var active           = $('#active').val();	
	var formData         = new FormData( $('#categoryDescriptionForm')[0] );	
	var message          = '';
	var flag             = 1 ;

	if( description_title == "" ){
		message = "Please enter description title";
		flag = 0;
		$('#description_title').focus();
		$('.message').addClass('error').html(message);
	}

	if( service_name == "-1" ){
		message = "Please select Service Name";
		flag = 0;
		$('#service_name').focus();
		$('.message').addClass('error').html(message);
	}	

	if( sort_order == "" ){
		message = "Please enter sort order";
		flag = 0;
		$('#sort_order').focus();
		$('.message').addClass('error').html(message);
	}

	if ( active == "-1" ){
		message = "Please select active";
		flag = 0;
		$('#active').focus();
		$('.message').addClass('error').html(message);
	}

	if ( flag == 1 ){
		$.ajax({
			url  : serverUrl+'PostCategoryDescriptionTitle.php',
			data : formData,
			method : 'POST',
			processData: false,
    		contentType: false,
			success: function( response ) {
				//console.log(response);
				var objData = JSON.parse( response );
				if( objData.code == 200 ){					
					message = objData.data;		
					setNotification( 'success', message, 'red' );
	                setTimeout(function() {
	                    window.location.reload(); }, 2500 );		       		
			    }
			   	if( objData.code == 404 || objData.code == 405 ){	       	
		   			message = objData.data;		
					setNotification( 'error', message, 'red' );
	                setTimeout(function() {
	                    window.location.reload(); }, 2500 );
		   		}	
		    },
		    error: function () {
		        if( response.code == 401 ){
		       		window.location.replace('/');		       	
		        }
		        $('.message').addClass('error').html(message);
		    } 
		});
	}

});

/*
* opens modal on click event handler
*/
$(document).on('click','.newTitle',function() {
	$('#categoryTitleModal').modal('show');
	$('#categoryDescTitle').html('New Category Description Title');
});

$(document).on( 'click', '.edit', function(){
    var id         		 = $(this).attr('data-id');
    var discTitle 		 = $(this).attr('data-discTitle');
    var serviceName  	 = $(this).attr('data-serviceName');
    var sortOrder  	 	 = $(this).attr('data-order');
    var status     	 	 = $(this).attr('data-status');

    $('#descriptionTitleModal').modal('show');
    $('#id').val(id);
    $('#desc_name').val(discTitle);
    $('#serv_name').val(serviceName);
    $('#sOrder').val(sortOrder);
    $('#status').val(status);
})


/*  update description title*/
$(document).on( 'click', '.updateDiscTitle', function(){

   var desc_name 			= $('#desc_name').val();
   var sort_order_validation    = $('#sOrder').val();
   var flag=1
            if ( desc_name == "" ) {
                 message = "Please Enter Your Description";
                 flag = 0;
                 $('.message').addClass('error').html(message);
                 $("#desc_name").focus();
             }
            if ( sort_order_validation == "" ) {
                 message = "Please Enter Your Sort Order";
                 flag = 0;
                 $('.message').addClass('error').html(message);
                 $("#sOrder").focus();
             }
		if(flag==1){
			var type = "descriptionTitle";
		    $.get("edit.php?type="+type,$( "#editDescriptionTitle" ).serialize(),function(data){
				setTimeout(function(){
					window.location.replace("description-title.php");
				}, 500);
    		});
		}
		});
