/*
* ------------------------------------------------------------------------------
* Category description title js file 
* Includes scripts for primary category management
* Author Dinesh Kumar Muthukrishnan 
* -------------------------------------------------------------------------------
*/

/*
* Clear message 
*/
$(document).ready(function() {
	$('.message').html('');	
	$('#descriptions-title-map').DataTable({
        'processing': true,
        'serverSide': true,
        'serverMethod': 'post',
        'ajax': {
            'url':'grid-descriptions.php'
        },
        "columnDefs": [
        	{"className": "dt-center", "targets": [-1,-2,-3,-4] }
      	],
        'columns': [
            { data: 'child_category_desc_title' },
            { data: 'description' },
            { data: 'sort_order' },
            { data: 'active' }, 
            { data: 'edit' },
            { data: 'delete' },                       
        ]
    });     
});
$("#category_desc_title").keyup(function() {
	var service_id = $('#service_id').val();
	$.ajax({
		type: "POST",
		url: "getTitleList.php",
		data:'keyword='+$(this).val()+'&service_id='+service_id,
		beforeSend: function(){
			if( service_id == '-1' ){	
				$('.message').addClass('error').html('Select child category');
				$('#category_name').css('border-color', 'red').focus();
			}
			$("#category_desc_title").css("background","#FFF url(dist/img/LoaderIcon.gif) no-repeat 165px");
		},
		success: function(data){
			$("#suggesstion-box").show();
			$("#suggesstion-box").html(data);
			$("#category_desc_title").css("background","#FFF");
		}
	});
});
/* selecting and making textbox value */
function selectTitle( title, id ) {
	$("#category_desc_title").val(title);
	$("#category_desc_title_id").val(id);
	$("#suggesstion-box").hide();	
}
/*
* Category description title click event handler
*/
$(document).on('click','#CategoryDescBtn',function() { 
	var description_title= $('#category_desc_title_id').val();
	var service_id       = $('#service_id').val();
	var sort_order       = $('#sort_order').val();
	var active           = $('#active').val();		
	var message          = '';
	var flag             = 1 ;
	var desc             = tinymce.get('descriptions').getContent();
	var formData         = new FormData($('#categoryDescForm'));	
	formData.append( 'descriptions', desc );
	formData.append( 'sort_order', sort_order );
	formData.append( 'category_desc_title_id', description_title );

	if( description_title == "" ){
		message = "Please enter description title";
		flag = 0;
		$('#category_desc_title').css('border-color', 'red').focus();
		$('.message').addClass('error').html(message);
	}	

	if( sort_order == "" ){
		message = "Please enter sort order";
		flag = 0;
		$('#sort_order').css('border-color', 'red').focus();
		$('.message').addClass('error').html(message);
	}

	if ( active == "-1" ){
		message = "Please select active";
		flag = 0;
		$('#active').css('border-color', 'red').focus();
		$('.message').addClass('error').html(message);
	}
	if ( flag == 1 ){
		$.ajax({
			url  : serverUrl+'PostCategoryDescriptions.php',
			data : formData,
			method : 'POST',
			processData: false,
    		contentType: false,
			success: function( response ) {
				console.log(response);
				var objData = JSON.parse( response );
				if( objData.code == 200 ){					
					message = objData.data;		
					setNotification( 'success', message, 'red' );
	                setTimeout(function() {
	                    window.location.href = objDataurl+'.php'; }, 2500 );		       		
			    }
			   	if( objData.code == 404 || objData.code == 405 ){	       	
		   			message = objData.data;		
					setNotification( 'error', message, 'red' );
	                setTimeout(function() {
	                    window.location.href = objDataurl+'.php'; }, 2500 );
		   		}	
		    },
		    error: function () {
		        if( response.code == 401 ){
		       		window.location.replace('/');		       	
		        }
		        $('.message').addClass('error').html(message);
		    } 
		});
	}
});

/*
* edit modal popup
* returns description details with matching record
* @params user_id
*/
$(document).on( 'click', '.edit', function(){
    var id          = $(this).attr('id');
    var description = $(this).attr('data-description');
    var sort_order  = $(this).attr('data-order');
    var status      = $(this).attr('data-status');
    /* getting meta info */
    var identifier  = $(this).attr('data-identifier');
    var table       = $(this).attr('data-table');
    var call_back   = $(this).attr('data-call_back');
    var extension   = $(this).attr('data-extension');

    $('#descriptionEditModal').modal('show');
    $('#description').html(description);
    tinymce.init({ selector:'.tinymce', branding: false  });
    $('#sort_order').val(sort_order);
    $('#status').val(status);
    /* setting meta info */
    $('#description_id').val(id);
    $('#identifier').val(identifier);
    $('#table').val(table);
    $('#call_back').val(call_back);
    $('#extension').val(extension);    
});
/*Description update script*/
$(document).on( 'click', '.updateDescription', function(){
    var description  = tinymce.get('description').getContent();
	var sort_order   = $('#sort_order').val();
	var status       = $('#status').val();
	var extension    = $('#extension').val();
	var key          = $('#identifier').val();
	var call_back    = $('#call_back').val();
	var table        = $('#table').val();
	var id           = $('#description_id').val();
    var flag=1
    if ( description == "" ) {
        message = "Please Enter Your Description";
        flag = 0;
        $('.message').addClass('error').html(message);
        $("#description").focus();
    }
    if ( sort_order == "" ) {
        message = "Please Enter Your Sort Order";
        flag = 0;
        $('.message').addClass('error').html(message);
        $("#sort_orde").focus();
    }
	if( flag == 1 ) {	
		var fdata =  new FormData();
		fdata.append('description', description );
	    fdata.append('type', 'descriptionEdit' );
	    fdata.append('sort_order', sort_order );
	    fdata.append('status', status );
	    fdata.append('id', id );
	    fdata.append('table', table );
	    fdata.append('call_back', call_back );
	    fdata.append('key', key );
	    $.ajax({
	        url : serverUrl+'edit'+extension,
	        method : 'POST',
	        data   : fdata,    
	        processData: false,
    		contentType: false,   
	        success:function( response ){
	        	console.log(response);
	        	var objData = JSON.parse(response);
	            if( objData.code == 200 ){		
					message = objData.data;			
					setNotification( 'success', message, 'green' );
	                setTimeout(function() {
	                    window.location.href = objData.url+extension }, 2500 );		       		
			    }
			   	if( objData.code == 404 || objData.code == 405 ) {	       	
		   			message = objData.data;
		   			setNotification( 'error', message, 'red' );
	                setTimeout(function() {
	                    window.location.href = objData.url+extension }, 2500 );
				}
	        },error: function() {
	        	if( response.code == 401 ){
		       		window.location.replace('/');		       	
		        }
		        $('.message').addClass('error').html(message);
	        }
	    });
	}
});