/*
* ------------------------------------------------------------------------------
* Common js file 
* Includes scripts for validations on form elements
* Author Dinesh Kumar Muthukrishnan 
* -------------------------------------------------------------------------------
*/

if ( location.hostname  == "localhost" ) {
    var serverUrl = "http://work.instasoft.co/workapp/console/";
}else{
    var serverUrl = "http://work.instasoft.co/workapp/console/";
}

/*
* Method for validating email
*/
function ValidateEmail(email) {
	if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email))	{
	    return true;
	}
	else{
		return false;
	}
}

/*
* Method for validating username
*/
function validateUsername( username ){
	var pattern = /^([_a-z0-9]+(\.[_a-z0-9]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,5}))|\d+$/;
	if( pattern.test(username) ){
		return true;
	}else{
		return false;
	}
}

/*
* Method for validating Phone
*/
function ValidatePhone( phone ){
	var pattern = /^([0-9]{10,10})$/;
	if( pattern.test(phone) ){
		return true;
	}else{
		return false;
	}
}
/*
* Method for validating Phone
*/
function ValidateNumber( no ){
	var pattern = /^([0-9])$/;
	if( pattern.test(no) ){
		return true;
	}else{
		return false;
	}
}
/*
* function to convert INR to words
*/

function convertNumberToWords(amount) {
    var words = new Array();
    words[0] = '';
    words[1] = 'One';
    words[2] = 'Two';
    words[3] = 'Three';
    words[4] = 'Four';
    words[5] = 'Five';
    words[6] = 'Six';
    words[7] = 'Seven';
    words[8] = 'Eight';
    words[9] = 'Nine';
    words[10] = 'Ten';
    words[11] = 'Eleven';
    words[12] = 'Twelve';
    words[13] = 'Thirteen';
    words[14] = 'Fourteen';
    words[15] = 'Fifteen';
    words[16] = 'Sixteen';
    words[17] = 'Seventeen';
    words[18] = 'Eighteen';
    words[19] = 'Nineteen';
    words[20] = 'Twenty';
    words[30] = 'Thirty';
    words[40] = 'Forty';
    words[50] = 'Fifty';
    words[60] = 'Sixty';
    words[70] = 'Seventy';
    words[80] = 'Eighty';
    words[90] = 'Ninety';
    amount = amount.toString();
    var atemp = amount.split(".");
    var number = atemp[0].split(",").join("");
    var n_length = number.length;
    var words_string = "";
    if (n_length <= 9) {
        var n_array = new Array(0, 0, 0, 0, 0, 0, 0, 0, 0);
        var received_n_array = new Array();
        for (var i = 0; i < n_length; i++) {
            received_n_array[i] = number.substr(i, 1);
        }
        for (var i = 9 - n_length, j = 0; i < 9; i++, j++) {
            n_array[i] = received_n_array[j];
        }
        for (var i = 0, j = 1; i < 9; i++, j++) {
            if (i == 0 || i == 2 || i == 4 || i == 7) {
                if (n_array[i] == 1) {
                    n_array[j] = 10 + parseInt(n_array[j]);
                    n_array[i] = 0;
                }
            }
        }
        value = "";
        for (var i = 0; i < 9; i++) {
            if (i == 0 || i == 2 || i == 4 || i == 7) {
                value = n_array[i] * 10;
            } else {
                value = n_array[i];
            }
            if (value != 0) {
                words_string += words[value] + " ";
            }
            if ((i == 1 && value != 0) || (i == 0 && value != 0 && n_array[i + 1] == 0)) {
                words_string += "Crores ";
            }
            if ((i == 3 && value != 0) || (i == 2 && value != 0 && n_array[i + 1] == 0)) {
                words_string += "Lakhs ";
            }
            if ((i == 5 && value != 0) || (i == 4 && value != 0 && n_array[i + 1] == 0)) {
                words_string += "Thousand ";
            }
            if (i == 6 && value != 0 && (n_array[i + 1] != 0 && n_array[i + 2] != 0)) {
                words_string += "Hundred and ";
            } else if (i == 6 && value != 0) {
                words_string += "Hundred ";
            }
        }
        words_string = words_string.split("  ").join(" ");
    }
    return words_string;
}

function withDecimal(no) {
    var nums = no.toString().split('.')
    var whole = convertNumberToWords(nums[0])
    if (nums.length == 2) {
        var fraction = convertNumberToWords(nums[1])
        return whole + 'and ' + fraction + 'paisa only';
    } else {
        return whole + 'Rupees only';
    }
}

/*
* To print
*/

$(document).on('click', '.print_link', function () {
    window.print();    
});


/*
* delete click event handler
*/
$(document).on('click','.delete',function() {
    var id         = $(this).attr('data-id');   
    var identifier = $(this).attr('data-identifier');   
    var table      = $(this).attr('data-table');    
    var call_back  = $(this).attr('data-call_back');    
    var extension  = $(this).attr('data-extension');    
    var formData   = new FormData();
    formData.append( 'identifier', identifier );
    formData.append( 'id', id );
    formData.append( 'table', table );
    formData.append( 'active', 0 );
    formData.append( 'call_back', call_back );
//alert(identifier);
    $.ajax({
        url  : serverUrl+'delete'+extension,
        method : 'POST',
        data   : formData,
        processData: false,
        contentType: false,
        success: function( response ) {
            //alert(response);
            var objData = JSON.parse( response );
            if( objData.code == 200 ){              
                message = objData.data;                
                var url = objData.url;
                setNotification('success', message, 'green' );
                setTimeout( function() { 
                    window.location.reload(); }, 2500 ); 
            }

            if( objData.code == 405 ) {              
                message = objData.data;                
                var url = objData.url;
                setNotification( 'error', message, 'red' );
                setTimeout(function() {
                   window.location.reload(); }, 2500 ); 
            }
        }
    });
});

/*
* SetNotification
* Parameter @type @messgae
* popups the notification
*/

function setNotification( type, message, color ) {
    $.toast({ 
      text : message, 
      icon : type,
      showHideTransition : 'slide',  
      bgColor : color,              
      textColor : '#eee',            
      allowToastClose : false,       
      hideAfter : 2000,              
      stack : 5,                     
      textAlign : 'left',            
      position : 'top-right' 
    });
}